/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Converter;

public class DefaultEntityMapping<C, I, T extends Table<T>>
implements EntityMapping<C, I, T> {
    private final EmbeddedClassMapping<C, T> mainMapping;
    private final Set<Column<T, ?>> insertableColumns = new KeepOrderSet();
    private final Set<Column<T, ?>> updatableColumns = new KeepOrderSet();
    private final Set<Column<T, ?>> selectableColumns = new KeepOrderSet();
    private final Map<ReversibleAccessor<C, ?>, EmbeddedBeanMapping<?, T>> embeddedMappings = new KeepOrderMap();
    private final IdMapping<C, I> idMapping;
    @Nullable
    private final Duo<ReversibleAccessor<C, ?>, Column<T, ?>> versioningMapping;
    private final boolean identifierSetByBeanFactory;

    public DefaultEntityMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> propertyToColumn, ReversibleAccessor<C, I> identifierProperty, IdentifierInsertionManager<C, I> identifierInsertionManager) {
        if (identifierProperty == null) {
            throw new UnsupportedOperationException("No identifier property for " + Reflections.toString(classToPersist));
        }
        if (((Table)targetTable).getPrimaryKey() == null) {
            throw new UnsupportedOperationException("No primary key column defined for " + ((Table)targetTable).getAbsoluteName());
        }
        this.mainMapping = new EmbeddedClassMapping<C, T>(classToPersist, targetTable, propertyToColumn);
        Column<T, ?> identifierColumn = propertyToColumn.get(identifierProperty);
        if (identifierColumn == null) {
            throw new IllegalArgumentException("Bean identifier '" + AccessorDefinition.toString(identifierProperty) + "' must have its matching column in the mapping");
        }
        if (!identifierColumn.isPrimaryKey()) {
            throw new UnsupportedOperationException("Accessor '" + AccessorDefinition.toString(identifierProperty) + "' is declared as identifier but mapped column " + identifierColumn + " is not the primary key of table");
        }
        this.idMapping = new SimpleIdMapping<C, I>(identifierProperty, identifierInsertionManager, new SingleIdentifierAssembler(identifierColumn));
        this.identifierSetByBeanFactory = false;
        this.versioningMapping = null;
        this.fillInsertableColumns();
        this.fillUpdatableColumns();
        this.fillSelectableColumns();
    }

    public DefaultEntityMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, ?>, Column<T, ?>> propertyToColumn, IdMapping<C, I> idMapping) {
        this(classToPersist, targetTable, propertyToColumn, Collections.emptyMap(), null, idMapping, null, false);
    }

    public DefaultEntityMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> propertyToColumn, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> readonlyColumns, @Nullable Duo<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> versioningMapping, IdMapping<C, I> idMapping, @Nullable Function<ColumnedRow, C> entityFactory, boolean identifierSetByBeanFactory) {
        if (idMapping.getIdAccessor() == null) {
            throw new UnsupportedOperationException("No identifier property defined for " + Reflections.toString(classToPersist));
        }
        if (((Table)targetTable).getPrimaryKey() == null) {
            throw new UnsupportedOperationException("No primary key column defined for " + ((Table)targetTable).getAbsoluteName());
        }
        KeepOrderMap readonlyPropertiesMapping = new KeepOrderMap(readonlyColumns);
        if (versioningMapping != null) {
            readonlyPropertiesMapping.put(versioningMapping.getLeft(), versioningMapping.getRight());
        }
        this.mainMapping = new EmbeddedClassMapping<C, T>(classToPersist, targetTable, propertyToColumn, readonlyPropertiesMapping, entityFactory);
        this.idMapping = idMapping;
        this.identifierSetByBeanFactory = identifierSetByBeanFactory;
        this.versioningMapping = versioningMapping;
        this.fillInsertableColumns();
        this.fillUpdatableColumns();
        this.fillSelectableColumns();
    }

    @Override
    public Class<C> getClassToPersist() {
        return this.mainMapping.getClassToPersist();
    }

    @Override
    public T getTargetTable() {
        return this.mainMapping.getTargetTable();
    }

    public EmbeddedClassMapping<C, T> getMainMapping() {
        return this.mainMapping;
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, EmbeddedBeanMapping<?, T>> getEmbeddedBeanStrategies() {
        return this.embeddedMappings;
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getPropertyToColumn() {
        KeepOrderMap result = new KeepOrderMap();
        result.putAll(this.getMainMapping().getPropertyToColumn());
        for (Map.Entry<ReversibleAccessor<C, ?>, EmbeddedBeanMapping<?, T>> value : this.embeddedMappings.entrySet()) {
            value.getValue().getPropertyToColumn().forEach((arg_0, arg_1) -> DefaultEntityMapping.lambda$getPropertyToColumn$0((Map)result, value, arg_0, arg_1));
        }
        return result;
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getReadonlyPropertyToColumn() {
        KeepOrderMap result = new KeepOrderMap();
        result.putAll(this.getMainMapping().getReadonlyPropertyToColumn());
        for (Map.Entry<ReversibleAccessor<C, ?>, EmbeddedBeanMapping<?, T>> value : this.embeddedMappings.entrySet()) {
            value.getValue().getReadonlyPropertyToColumn().forEach((arg_0, arg_1) -> DefaultEntityMapping.lambda$getReadonlyPropertyToColumn$1((Map)result, value, arg_0, arg_1));
        }
        return result;
    }

    @Override
    @Nullable
    public Duo<ReversibleAccessor<C, ?>, Column<T, ?>> getVersioningMapping() {
        return this.versioningMapping;
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
        return this.mainMapping.getReadConverters();
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
        return this.mainMapping.getWriteConverters();
    }

    @Override
    public Set<Column<T, ?>> getInsertableColumns() {
        return Collections.unmodifiableSet(this.insertableColumns);
    }

    @Override
    public Set<Column<T, ?>> getUpdatableColumns() {
        return Collections.unmodifiableSet(this.updatableColumns);
    }

    @Override
    public Set<Column<T, ?>> getSelectableColumns() {
        return Collections.unmodifiableSet(this.selectableColumns);
    }

    @Override
    public IdMapping<C, I> getIdMapping() {
        return this.idMapping;
    }

    public Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForInsert() {
        return Collections.unmodifiableCollection(this.mainMapping.getShadowColumnsForInsert());
    }

    public Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForUpdate() {
        return Collections.unmodifiableCollection(this.mainMapping.getShadowColumnsForUpdate());
    }

    public void addShadowColumns(DefaultEntityMapping<C, I, T> entityMapping) {
        entityMapping.mainMapping.getShadowColumnsForInsert().forEach(this::addShadowColumnInsert);
        entityMapping.mainMapping.getShadowColumnsForUpdate().forEach(this::addShadowColumnUpdate);
    }

    @Override
    public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.mainMapping.addShadowColumnInsert(valueProvider);
        this.insertableColumns.addAll(valueProvider.getColumns());
    }

    @Override
    public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.mainMapping.addShadowColumnUpdate(valueProvider);
        this.updatableColumns.addAll(valueProvider.getColumns());
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<C> accessor) {
        this.mainMapping.addPropertySetByConstructor(accessor);
    }

    @Override
    public <O> void addShadowColumnSelect(Column<T, O> column) {
        this.mainMapping.addShadowColumnSelect(column);
        this.fillSelectableColumns();
    }

    public <O> void put(ReversibleAccessor<C, O> property, EmbeddedBeanMapping<O, T> mappingStrategy) {
        this.embeddedMappings.put(property, mappingStrategy);
        this.addInsertableColumns(mappingStrategy);
        this.addUpdatableColumns(mappingStrategy);
        this.addSelectableColumns(mappingStrategy);
    }

    @Override
    public Map<Column<T, ?>, ?> getInsertValues(C c) {
        Map insertValues = this.mainMapping.getInsertValues(c);
        this.getVersionedKeyValues(c).entrySet().stream().filter(entry -> !((Column)entry.getKey()).isAutoGenerated()).forEach(entry -> insertValues.put((Column)entry.getKey(), entry.getValue()));
        this.foreachMappedField(mappingEntry -> {
            Object fieldValue = ((ReversibleAccessor)mappingEntry.getKey()).get(c);
            Map fieldInsertValues = ((EmbeddedBeanMapping)mappingEntry.getValue()).getInsertValues(fieldValue);
            insertValues.putAll(fieldInsertValues);
        });
        return insertValues;
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, ?> getUpdateValues(C modified, C unmodified, boolean allColumns) {
        Map<Mapping.UpwhereColumn<T>, Object> toReturn;
        if (modified != null && unmodified != null && !this.getId(modified).equals(this.getId(unmodified))) {
            toReturn = new HashMap<Mapping.UpwhereColumn<T>, Object>();
        } else {
            toReturn = this.mainMapping.getUpdateValues(modified, unmodified, allColumns);
            this.foreachMappedField(mappingEntry -> {
                ReversibleAccessor accessor = (ReversibleAccessor)mappingEntry.getKey();
                Object modifiedValue = accessor.get(modified);
                Object unmodifiedValue = unmodified == null ? null : accessor.get(unmodified);
                Map fieldUpdateValues = ((EmbeddedBeanMapping)mappingEntry.getValue()).getUpdateValues(modifiedValue, unmodifiedValue, allColumns);
                toReturn.putAll(fieldUpdateValues);
            });
            if (!toReturn.isEmpty()) {
                if (allColumns) {
                    HashSet<Column<T, Column<T, Object>>> missingColumns = new HashSet<Column<T, Column<T, Object>>>(this.getUpdatableColumns());
                    missingColumns.removeAll(Mapping.UpwhereColumn.getUpdateColumns(toReturn).keySet());
                    for (Column column : missingColumns) {
                        toReturn.put(new Mapping.UpwhereColumn(column, true), null);
                    }
                }
                Object whereSource = unmodified != null ? unmodified : modified;
                for (Map.Entry<Column<T, ?>, ?> entry : this.getVersionedKeyValues(whereSource).entrySet()) {
                    toReturn.put(new Mapping.UpwhereColumn<T>(entry.getKey(), false), entry.getValue());
                }
            }
        }
        return toReturn;
    }

    private <E> void foreachMappedField(Consumer<Map.Entry<ReversibleAccessor<C, E>, EmbeddedBeanMapping<E, T>>> consumer) {
        this.embeddedMappings.entrySet().forEach(consumer);
    }

    private void fillInsertableColumns() {
        this.insertableColumns.clear();
        this.addInsertableColumns(this.mainMapping);
        this.insertableColumns.addAll(this.getIdMapping().getIdentifierAssembler().getColumns());
        this.embeddedMappings.values().forEach(this::addInsertableColumns);
        if (this.versioningMapping != null) {
            this.insertableColumns.add((Column<T, ?>)this.versioningMapping.getRight());
        }
    }

    private void addInsertableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.insertableColumns.addAll(embeddedBeanMapping.getWritableColumns());
    }

    private void fillUpdatableColumns() {
        this.updatableColumns.clear();
        this.addUpdatableColumns(this.mainMapping);
        this.embeddedMappings.values().forEach(this::addUpdatableColumns);
        if (this.versioningMapping != null) {
            this.updatableColumns.add((Column<T, ?>)this.versioningMapping.getRight());
        }
        this.updatableColumns.removeAll((Collection<?>)((Table)this.getTargetTable()).getPrimaryKey().getColumns());
        this.updatableColumns.removeIf(Column::isAutoGenerated);
    }

    private void addUpdatableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.updatableColumns.addAll(embeddedBeanMapping.getWritableColumns());
    }

    private void fillSelectableColumns() {
        this.selectableColumns.clear();
        this.addSelectableColumns(this.mainMapping);
        this.selectableColumns.addAll(this.getIdMapping().getIdentifierAssembler().getColumns());
        if (this.versioningMapping != null) {
            this.selectableColumns.add((Column<T, ?>)this.versioningMapping.getRight());
        }
        this.embeddedMappings.values().forEach(this::addSelectableColumns);
    }

    private void addSelectableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.selectableColumns.addAll(embeddedBeanMapping.getColumns());
    }

    @Override
    public Map<Column<T, ?>, ?> getVersionedKeyValues(C c) {
        HashMap<Object, Object> toReturn = new HashMap<Object, Object>();
        toReturn.putAll(this.getIdMapping().getIdentifierAssembler().getColumnValues(this.getId(c)));
        if (this.versioningMapping != null) {
            toReturn.put(this.versioningMapping.getRight(), ((ReversibleAccessor)this.versioningMapping.getLeft()).get(c));
        }
        return toReturn;
    }

    @Override
    public Iterable<Column<T, ?>> getVersionedKeys() {
        KeepOrderSet columns = new KeepOrderSet();
        if (this.versioningMapping != null) {
            columns.add(this.versioningMapping.getRight());
        }
        columns.addAll(((Table)this.getTargetTable()).getPrimaryKey().getColumns());
        return Collections.unmodifiableSet(columns);
    }

    @Override
    public I getId(C c) {
        return this.getIdMapping().getIdAccessor().getId(c);
    }

    @Override
    public void setId(C c, I identifier) {
        this.getIdMapping().getIdAccessor().setId(c, identifier);
    }

    @Override
    public boolean isNew(C c) {
        return this.getIdMapping().isNew(c);
    }

    @Override
    public C transform(ColumnedRow row) {
        return this.getRowTransformer().transform(row);
    }

    @Override
    public RowTransformer<C> getRowTransformer() {
        return new RowTransformer<C>(){

            @Override
            public C transform(ColumnedRow row) {
                Object toReturn = DefaultEntityMapping.this.mainMapping.getRowTransformer().transform(row);
                if (!DefaultEntityMapping.this.identifierSetByBeanFactory) {
                    DefaultEntityMapping.this.setId(toReturn, DefaultEntityMapping.this.getIdMapping().getIdentifierAssembler().assemble(row));
                }
                DefaultEntityMapping.this.foreachMappedField(mappingEntry -> ((ReversibleAccessor)mappingEntry.getKey()).toMutator().set(toReturn, ((EmbeddedBeanMapping)mappingEntry.getValue()).transform(row)));
                return toReturn;
            }

            @Override
            public C newBeanInstance(ColumnedRow row) {
                return DefaultEntityMapping.this.mainMapping.transform(row);
            }

            @Override
            public void applyRowToBean(ColumnedRow row, C bean) {
                DefaultEntityMapping.this.mainMapping.getRowTransformer().applyRowToBean(row, bean);
            }

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<? extends C> listener) {
                DefaultEntityMapping.this.mainMapping.addTransformerListener(listener);
            }
        };
    }

    @Override
    public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
        this.getRowTransformer().addTransformerListener(listener);
    }

    private static /* synthetic */ void lambda$getReadonlyPropertyToColumn$1(Map result, Map.Entry value, ReversibleAccessor k, Column v) {
        if (!(k instanceof ReversibleMutator)) {
            throw new UnsupportedOperationException("Given accessor " + AccessorDefinition.toString((ValueAccessPoint)k) + " can't be converted to an Accessor to make it last element of Accessor chain");
        }
        Accessor kAsAccessor = ((ReversibleMutator)k).toAccessor();
        result.put(new AccessorChain(new Accessor[]{(Accessor)value.getKey(), kAsAccessor}).toMutator(), v);
    }

    private static /* synthetic */ void lambda$getPropertyToColumn$0(Map result, Map.Entry value, ReversibleAccessor k, Column v) {
        result.put(new AccessorChain(new Accessor[]{(Accessor)value.getKey(), k}), v);
    }
}

